/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.region.localneighborhood;

import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.region.localneighborhood.HyperSphereNeighborhoodFactory;
import net.imglib2.algorithm.region.localneighborhood.HypersphereNeighborhoodLocalizableSampler;
import net.imglib2.algorithm.region.localneighborhood.Neighborhood;
import net.imglib2.util.IntervalIndexer;

public final class HyperSphereNeighborhoodCursor<T>
extends HypersphereNeighborhoodLocalizableSampler<T>
implements Cursor<Neighborhood<T>> {
    private final long[] dimensions;
    private long index;
    private final long maxIndex;
    private long maxIndexOnLine;

    public HyperSphereNeighborhoodCursor(RandomAccessibleInterval<T> source, long radius, HyperSphereNeighborhoodFactory<T> factory) {
        super(source, radius, factory);
        this.dimensions = new long[this.n];
        this.dimensions(this.dimensions);
        long size = this.dimensions[0];
        for (int d = 1; d < this.n; ++d) {
            size *= this.dimensions[d];
        }
        this.maxIndex = size;
        this.reset();
    }

    private HyperSphereNeighborhoodCursor(HyperSphereNeighborhoodCursor<T> c) {
        super(c);
        this.dimensions = (long[])c.dimensions.clone();
        this.maxIndex = c.maxIndex;
        this.index = c.index;
        this.maxIndexOnLine = c.maxIndexOnLine;
    }

    public void fwd() {
        this.currentPos[0] = this.currentPos[0] + 1L;
        if (++this.index > this.maxIndexOnLine) {
            this.nextLine();
        }
    }

    private void nextLine() {
        this.currentPos[0] = this.min[0];
        this.maxIndexOnLine += this.dimensions[0];
        for (int d = 1; d < this.n; ++d) {
            int n = d;
            this.currentPos[n] = this.currentPos[n] + 1L;
            if (this.currentPos[d] <= this.max[d]) break;
            this.currentPos[d] = this.min[d];
        }
    }

    public void reset() {
        this.index = 0L;
        this.maxIndexOnLine = this.dimensions[0];
        for (int d = 0; d < this.n; ++d) {
            this.currentPos[d] = d == 0 ? this.min[d] - 1L : this.min[d];
        }
    }

    public boolean hasNext() {
        return this.index < this.maxIndex;
    }

    public void jumpFwd(long steps) {
        this.index += steps;
        this.maxIndexOnLine = this.index < 0L ? this.dimensions[0] : (1L + this.index / this.dimensions[0]) * this.dimensions[0];
        IntervalIndexer.indexToPositionWithOffset((long)(this.index + 1L), (long[])this.dimensions, (long[])this.min, (long[])this.currentPos);
    }

    public Neighborhood<T> next() {
        this.fwd();
        return this.get();
    }

    public void remove() {
    }

    public HyperSphereNeighborhoodCursor<T> copy() {
        return new HyperSphereNeighborhoodCursor<T>(this);
    }

    public HyperSphereNeighborhoodCursor<T> copyCursor() {
        return this.copy();
    }
}

