/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.region.localneighborhood;

import net.imglib2.AbstractInterval;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.Sampler;
import net.imglib2.algorithm.region.localneighborhood.Neighborhood;
import net.imglib2.algorithm.region.localneighborhood.RectangleNeighborhoodFactory;

public abstract class RectangleNeighborhoodLocalizableSampler<T>
extends AbstractInterval
implements Localizable,
Sampler<Neighborhood<T>> {
    protected final RandomAccessibleInterval<T> source;
    protected final Interval span;
    protected final RectangleNeighborhoodFactory<T> neighborhoodFactory;
    protected final Neighborhood<T> currentNeighborhood;
    protected final long[] currentPos;
    protected final long[] currentMin;
    protected final long[] currentMax;

    public RectangleNeighborhoodLocalizableSampler(RandomAccessibleInterval<T> source, Interval span, RectangleNeighborhoodFactory<T> factory) {
        super(source);
        this.source = source;
        this.span = span;
        this.neighborhoodFactory = factory;
        this.currentPos = new long[this.n];
        this.currentMin = new long[this.n];
        this.currentMax = new long[this.n];
        long[] accessMin = new long[this.n];
        long[] accessMax = new long[this.n];
        source.min(accessMin);
        source.max(accessMax);
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            accessMin[n] = accessMin[n] + span.min(d);
            int n2 = d;
            accessMax[n2] = accessMax[n2] + span.max(d);
        }
        this.currentNeighborhood = this.neighborhoodFactory.create(this.currentPos, this.currentMin, this.currentMax, span, source.randomAccess((Interval)new FinalInterval(accessMin, accessMax)));
    }

    protected RectangleNeighborhoodLocalizableSampler(RectangleNeighborhoodLocalizableSampler<T> c) {
        super(c.source);
        this.source = c.source;
        this.span = c.span;
        this.neighborhoodFactory = c.neighborhoodFactory;
        this.currentPos = (long[])c.currentPos.clone();
        this.currentMin = (long[])c.currentMin.clone();
        this.currentMax = (long[])c.currentMax.clone();
        this.currentNeighborhood = this.neighborhoodFactory.create(this.currentPos, this.currentMin, this.currentMax, this.span, this.source.randomAccess());
    }

    public Neighborhood<T> get() {
        return this.currentNeighborhood;
    }

    public void localize(int[] position) {
        this.currentNeighborhood.localize(position);
    }

    public void localize(long[] position) {
        this.currentNeighborhood.localize(position);
    }

    public int getIntPosition(int d) {
        return this.currentNeighborhood.getIntPosition(d);
    }

    public long getLongPosition(int d) {
        return this.currentNeighborhood.getLongPosition(d);
    }

    public void localize(float[] position) {
        this.currentNeighborhood.localize(position);
    }

    public void localize(double[] position) {
        this.currentNeighborhood.localize(position);
    }

    public float getFloatPosition(int d) {
        return this.currentNeighborhood.getFloatPosition(d);
    }

    public double getDoublePosition(int d) {
        return this.currentNeighborhood.getDoublePosition(d);
    }
}

