/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.region.localneighborhood;

import java.util.Iterator;
import net.imglib2.AbstractInterval;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.FlatIterationOrder;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.IterableRealInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.region.localneighborhood.Neighborhood;
import net.imglib2.algorithm.region.localneighborhood.RectangleNeighborhood;
import net.imglib2.algorithm.region.localneighborhood.RectangleNeighborhoodCursor;
import net.imglib2.algorithm.region.localneighborhood.RectangleNeighborhoodFactory;
import net.imglib2.algorithm.region.localneighborhood.RectangleNeighborhoodRandomAccess;
import net.imglib2.algorithm.region.localneighborhood.RectangleNeighborhoodSkipCenter;
import net.imglib2.algorithm.region.localneighborhood.RectangleNeighborhoodSkipCenterUnsafe;
import net.imglib2.algorithm.region.localneighborhood.RectangleNeighborhoodUnsafe;
import net.imglib2.algorithm.region.localneighborhood.Shape;

public class RectangleShape
implements Shape {
    final int span;
    final boolean skipCenter;

    public RectangleShape(int span, boolean skipCenter) {
        this.span = span;
        this.skipCenter = skipCenter;
    }

    public <T> NeighborhoodsAccessible<T> neighborhoods(RandomAccessibleInterval<T> source) {
        return this.neighborhoodsRandomAccessible((RandomAccessibleInterval)source);
    }

    public <T> NeighborhoodsAccessible<T> neighborhoodsRandomAccessible(RandomAccessibleInterval<T> source) {
        RectangleNeighborhoodFactory f = this.skipCenter ? RectangleNeighborhoodSkipCenterUnsafe.factory() : RectangleNeighborhoodUnsafe.factory();
        Interval spanInterval = this.createSpan(source.numDimensions());
        return new NeighborhoodsAccessible<T>(source, spanInterval, f);
    }

    public <T> NeighborhoodsAccessible<T> neighborhoodsSafe(RandomAccessibleInterval<T> source) {
        return this.neighborhoodsRandomAccessibleSafe((RandomAccessibleInterval)source);
    }

    public <T> NeighborhoodsAccessible<T> neighborhoodsRandomAccessibleSafe(RandomAccessibleInterval<T> source) {
        RectangleNeighborhoodFactory f = this.skipCenter ? RectangleNeighborhoodSkipCenter.factory() : RectangleNeighborhood.factory();
        Interval spanInterval = this.createSpan(source.numDimensions());
        return new NeighborhoodsAccessible<T>(source, spanInterval, f);
    }

    private Interval createSpan(int n) {
        long[] min = new long[n];
        long[] max = new long[n];
        for (int d = 0; d < n; ++d) {
            min[d] = -this.span;
            max[d] = this.span;
        }
        return new FinalInterval(min, max);
    }

    public static final class NeighborhoodsAccessible<T>
    extends AbstractInterval
    implements RandomAccessibleInterval<Neighborhood<T>>,
    IterableInterval<Neighborhood<T>> {
        final RandomAccessibleInterval<T> source;
        final Interval span;
        final RectangleNeighborhoodFactory<T> factory;
        final long size;

        public NeighborhoodsAccessible(RandomAccessibleInterval<T> source, Interval span, RectangleNeighborhoodFactory<T> factory) {
            super(source);
            this.source = source;
            this.span = span;
            this.factory = factory;
            long s = source.dimension(0);
            for (int d = 1; d < this.n; ++d) {
                s *= source.dimension(d);
            }
            this.size = s;
        }

        public RandomAccess<Neighborhood<T>> randomAccess() {
            return new RectangleNeighborhoodRandomAccess<T>(this.source, this.span, this.factory);
        }

        public Cursor<Neighborhood<T>> cursor() {
            return new RectangleNeighborhoodCursor<T>(this.source, this.span, this.factory);
        }

        public RandomAccess<Neighborhood<T>> randomAccess(Interval interval) {
            return this.randomAccess();
        }

        public long size() {
            return this.size;
        }

        public Neighborhood<T> firstElement() {
            return (Neighborhood)this.cursor().next();
        }

        public Object iterationOrder() {
            return new FlatIterationOrder((Interval)this);
        }

        public boolean equalIterationOrder(IterableRealInterval<?> f) {
            return this.iterationOrder().equals(f.iterationOrder());
        }

        public Iterator<Neighborhood<T>> iterator() {
            return this.cursor();
        }

        public Cursor<Neighborhood<T>> localizingCursor() {
            return this.cursor();
        }
    }
}

