/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.trainable_segmention;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.imagej.ops.OpEnvironment;
import net.imagej.ops.OpService;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.gauss3.Gauss3;
import net.imglib2.converter.Converter;
import net.imglib2.converter.Converters;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.outofbounds.OutOfBoundsBorderFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Intervals;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import net.imglib2.view.composite.Composite;
import weka.core.DenseInstance;

public class RevampUtils {
    private static final float[] SOBEL_FILTER_X_VALUES = new float[]{1.0f, 2.0f, 1.0f, 0.0f, 0.0f, 0.0f, -1.0f, -2.0f, -1.0f};
    private static final RandomAccessibleInterval<FloatType> SOBEL_FILTER_X = ArrayImgs.floats((float[])SOBEL_FILTER_X_VALUES, (long[])new long[]{3L, 3L});
    private static final float[] SOBEL_FILTER_Y_VALUES = new float[]{1.0f, 0.0f, -1.0f, 2.0f, 0.0f, -2.0f, 1.0f, 0.0f, -1.0f};
    private static final RandomAccessibleInterval<FloatType> SOBEL_FILTER_Y = ArrayImgs.floats((float[])SOBEL_FILTER_Y_VALUES, (long[])new long[]{3L, 3L});

    public static <T> List<RandomAccessibleInterval<T>> slices(RandomAccessibleInterval<T> output) {
        int axis = output.numDimensions() - 1;
        return LongStream.range(output.min(axis), output.max(axis) + 1L).mapToObj(pos -> Views.hyperSlice((RandomAccessibleInterval)output, (int)axis, (long)pos)).collect(Collectors.toList());
    }

    public static long[] extend(long[] in, long elem) {
        long[] result = new long[in.length + 1];
        System.arraycopy(in, 0, result, 0, in.length);
        result[in.length] = elem;
        return result;
    }

    public static int[] extend(int[] in, int elem) {
        int[] result = new int[in.length + 1];
        System.arraycopy(in, 0, result, 0, in.length);
        result[in.length] = elem;
        return result;
    }

    public static Interval appendDimensionToInterval(Interval in, long min, long max) {
        int n = in.numDimensions();
        long[] mins = new long[n + 1];
        long[] maxs = new long[n + 1];
        for (int i = 0; i < n; ++i) {
            mins[i] = in.min(i);
            maxs[i] = in.max(i);
        }
        mins[n] = min;
        maxs[n] = max;
        return new FinalInterval(mins, maxs);
    }

    public static Interval removeLastDimension(Interval in) {
        long[] min = RevampUtils.removeLast(Intervals.minAsLongArray((Interval)in));
        long[] max = RevampUtils.removeLast(Intervals.maxAsLongArray((Interval)in));
        return new FinalInterval(min, max);
    }

    private static long[] removeLast(long[] longs) {
        return Arrays.copyOf(longs, longs.length - 1);
    }

    public static RandomAccessibleInterval<FloatType> gauss(OpService ops, RandomAccessibleInterval<FloatType> image, double[] sigmas) {
        Img blurred = ops.create().img(image);
        ops.filter().gauss((RandomAccessibleInterval)blurred, image, sigmas, (OutOfBoundsFactory)new OutOfBoundsBorderFactory());
        return blurred;
    }

    public static RandomAccessibleInterval<FloatType> gauss(OpEnvironment ops, RandomAccessible<FloatType> input, Interval outputInterval, double[] sigmas) {
        Img blurred = ops.create().img((Dimensions)outputInterval, (NativeType)new FloatType());
        try {
            Gauss3.gauss((double[])sigmas, input, (RandomAccessibleInterval)blurred, (ExecutorService)Executors.newSingleThreadExecutor());
        }
        catch (IncompatibleTypeException e) {
            throw new RuntimeException(e);
        }
        return blurred;
    }

    public static Interval gaussRequiredInput(Interval outputInterval, double[] sigmas) {
        long[] border = IntStream.of(Gauss3.halfkernelsizes((double[])sigmas)).mapToLong(x -> x - 1).toArray();
        return Intervals.expand((Interval)outputInterval, (long[])border);
    }

    public static RandomAccessibleInterval<FloatType> deriveX(OpEnvironment ops, RandomAccessible<FloatType> input, Interval outputInterval) {
        if (outputInterval.numDimensions() != 2) {
            throw new IllegalArgumentException("Only two dimensional images supported.");
        }
        Img output = ops.create().img((Dimensions)outputInterval, (NativeType)new FloatType());
        ops.filter().convolve((RandomAccessibleInterval)output, input, SOBEL_FILTER_X);
        return output;
    }

    public static Interval deriveXRequiredInput(Interval output) {
        if (output.numDimensions() != 2) {
            throw new IllegalArgumentException("Only two dimensional images supported.");
        }
        return Intervals.expand((Interval)output, (long[])new long[]{1L, 1L});
    }

    public static RandomAccessibleInterval<FloatType> deriveY(OpEnvironment ops, RandomAccessible<FloatType> input, Interval outputInterval) {
        if (outputInterval.numDimensions() != 2) {
            throw new IllegalArgumentException("Only two dimensional images supported.");
        }
        Img output = ops.create().img((Dimensions)outputInterval, (NativeType)new FloatType());
        ops.filter().convolve((RandomAccessibleInterval)output, input, SOBEL_FILTER_Y);
        return output;
    }

    public static Interval deriveYRequiredInput(Interval output) {
        if (output.numDimensions() != 2) {
            throw new IllegalArgumentException("Only two dimensional images supported.");
        }
        return Intervals.expand((Interval)output, (long[])new long[]{1L, 1L});
    }

    public static RandomAccessibleInterval<FloatType> convolve(OpService ops, RandomAccessibleInterval<FloatType> blurred, RandomAccessibleInterval<FloatType> kernel) {
        return ops.filter().convolve(blurred, kernel, (OutOfBoundsFactory)new OutOfBoundsBorderFactory());
    }

    public static RandomAccessibleInterval<IntType> toInt(RandomAccessibleInterval<FloatType> input) {
        Converter floatToInt = (in, out) -> out.set((int)in.get());
        return Converters.convert(input, (Converter)floatToInt, (Type)new IntType());
    }

    public static RandomAccessibleInterval<FloatType> toFloat(RandomAccessibleInterval<? extends RealType<?>> input) {
        if (input.randomAccess().get() instanceof FloatType) {
            return (RandomAccessibleInterval)RevampUtils.uncheckedCast(input);
        }
        Converter intToFloat = (in, out) -> out.set(in.getRealFloat());
        return Converters.convert(input, (Converter)intToFloat, (Type)new FloatType());
    }

    public static RandomAccessible<FloatType> randomAccessibleToFloat(RandomAccessible<? extends RealType<?>> input) {
        if (input.randomAccess().get() instanceof FloatType) {
            return (RandomAccessible)RevampUtils.uncheckedCast(input);
        }
        Converter intToFloat = (in, out) -> out.set(in.getRealFloat());
        return Converters.convert(input, (Converter)intToFloat, (Type)new FloatType());
    }

    private static Img<FloatType> copy(OpEnvironment ops, IterableInterval<FloatType> input) {
        Img result = ops.create().img(input, (NativeType)input.firstElement());
        ops.copy().iterableInterval((IterableInterval)result, input);
        return result;
    }

    public static Img<FloatType> copy(OpEnvironment ops, RandomAccessibleInterval<FloatType> input) {
        return RevampUtils.copy(ops, (IterableInterval<FloatType>)Views.iterable(input));
    }

    public static <T extends ComplexType<T>> boolean containsNaN(RandomAccessibleInterval<T> result) {
        for (ComplexType value : Views.iterable(result)) {
            if (!Double.isNaN(value.getRealDouble())) continue;
            return true;
        }
        return false;
    }

    public static long[] nCopies(int count, long value) {
        long[] result = new long[count];
        Arrays.fill(result, value);
        return result;
    }

    public static double[] nCopies(int count, double value) {
        double[] result = new double[count];
        Arrays.fill(result, value);
        return result;
    }

    public static Iterable<Localizable> neigborsLocations(int n) {
        ArrayImg img = ArrayImgs.bytes((long[])RevampUtils.nCopies(n, 3L));
        IntervalView translate = Views.translate((RandomAccessibleInterval)img, (long[])RevampUtils.nCopies(n, -1L));
        final Cursor cursor = translate.localizingCursor();
        return () -> new Iterator<Localizable>(){

            @Override
            public boolean hasNext() {
                return cursor.hasNext();
            }

            @Override
            public Localizable next() {
                cursor.fwd();
                return cursor;
            }
        };
    }

    public static double distance(Localizable a, Localizable b) {
        int n = a.numDimensions();
        long sum = 0L;
        for (int i = 0; i < n; ++i) {
            long difference = a.getLongPosition(i) - b.getLongPosition(i);
            sum += difference * difference;
        }
        return Math.sqrt(sum);
    }

    public static <T> List<T> filterForClass(Class<T> tClass, List<?> in) {
        return in.stream().filter(tClass::isInstance).map(tClass::cast).collect(Collectors.toList());
    }

    public static Object[] prepend(Object x, Object[] xs) {
        return Stream.concat(Stream.of(x), Stream.of(xs)).toArray();
    }

    public static void wrapException(RunnableWithException r) {
        try {
            r.run();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static <R> R wrapException(SupplierWithException<R> r) {
        try {
            return r.get();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static DenseInstance getInstance(int featureCount, int classIndex, Composite<? extends RealType<?>> featureValues) {
        double[] values = new double[featureCount + 1];
        for (int i = 0; i < featureCount; ++i) {
            values[i] = ((RealType)featureValues.get((long)i)).getRealDouble();
        }
        values[featureCount] = classIndex;
        return new DenseInstance(1.0, values);
    }

    public static void copyInteger(RandomAccessibleInterval<? extends IntegerType<?>> in, RandomAccessibleInterval<? extends IntegerType<?>> result) {
        Views.interval((RandomAccessible)Views.pair(in, result), in).forEach(p -> ((IntegerType)p.getB()).setInteger(((IntegerType)p.getA()).getInteger()));
    }

    public static List<RandomAccessible<FloatType>> splitChannels(RandomAccessible<ARGBType> image) {
        return RevampUtils.convertersStream().map(x -> Converters.convert((RandomAccessible)image, (Converter)x, (Type)new FloatType())).collect(Collectors.toList());
    }

    public static List<RandomAccessibleInterval<FloatType>> splitChannels(RandomAccessibleInterval<ARGBType> image) {
        return RevampUtils.convertersStream().map(x -> Converters.convert((RandomAccessibleInterval)image, (Converter)x, (Type)new FloatType())).collect(Collectors.toList());
    }

    private static Stream<Converter<ARGBType, FloatType>> convertersStream() {
        return Stream.of(ARGBType::red, ARGBType::green, ARGBType::blue).map(RevampUtils::converter);
    }

    private static Converter<ARGBType, FloatType> converter(IntToIntFunction f) {
        return (in, out) -> out.set((float)f.apply(in.get()) / 255.0f);
    }

    public static <T> T uncheckedCast(Object input) {
        Object result = input;
        return (T)result;
    }

    public static <T> RandomAccessible<T> castRandomAccessible(RandomAccessible<?> input, Class<T> tClass) {
        if (tClass.isInstance(input.randomAccess().get())) {
            return (RandomAccessible)RevampUtils.uncheckedCast(input);
        }
        throw new IllegalArgumentException("RandomAccessible input must be of type " + tClass.getName());
    }

    public static Interval intervalRemoveDimension(Interval interval) {
        return RevampUtils.intervalRemoveDimension(interval, interval.numDimensions() - 1);
    }

    public static Interval intervalRemoveDimension(Interval interval, int d) {
        long[] min = RevampUtils.removeElement(Intervals.minAsLongArray((Interval)interval), d);
        long[] max = RevampUtils.removeElement(Intervals.maxAsLongArray((Interval)interval), d);
        return new FinalInterval(min, max);
    }

    private static long[] removeElement(long[] values, int d) {
        long[] result = new long[values.length - 1];
        System.arraycopy(values, 0, result, 0, d);
        System.arraycopy(values, d + 1, result, d, values.length - d - 1);
        return result;
    }

    private static interface IntToIntFunction {
        public int apply(int var1);
    }

    public static interface SupplierWithException<R> {
        public R get() throws Exception;
    }

    public static interface RunnableWithException {
        public void run() throws Exception;
    }
}

