/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.trainable_segmention.gui;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.imglib2.trainable_segmention.pixel_feature.filter.FeatureOp;
import net.imglib2.trainable_segmention.pixel_feature.settings.GlobalSettings;
import org.scijava.Context;
import org.scijava.InstantiableException;
import org.scijava.plugin.PluginInfo;
import org.scijava.plugin.PluginService;

public class AvailableFeatures {
    Context context;

    AvailableFeatures(Context context) {
        this.context = context;
    }

    public static Map<String, Class<? extends FeatureOp>> getMap(Context context, GlobalSettings globals) {
        TreeMap<String, Class<? extends FeatureOp>> map = new TreeMap<String, Class<? extends FeatureOp>>();
        List pi = ((PluginService)context.service(PluginService.class)).getPluginsOfType(FeatureOp.class);
        for (PluginInfo pluginInfo : pi) {
            try {
                if (!AvailableFeatures.isValid((PluginInfo<FeatureOp>)pluginInfo, globals)) continue;
                map.put(AvailableFeatures.getLabel((PluginInfo<FeatureOp>)pluginInfo), pluginInfo.loadClass());
            }
            catch (InstantiableException instantiableException) {}
        }
        return map;
    }

    private static boolean isValid(PluginInfo<FeatureOp> pluginInfo, GlobalSettings globals) throws InstantiableException {
        FeatureOp op = (FeatureOp)pluginInfo.createInstance();
        return op.checkGlobalSettings(globals);
    }

    private static String getLabel(PluginInfo<FeatureOp> pluginInfo) throws InstantiableException {
        String label = pluginInfo.getLabel();
        return label.isEmpty() ? pluginInfo.loadClass().getSimpleName() : label;
    }
}

