/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.trainable_segmention.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import net.imglib2.trainable_segmention.gui.AvailableFeatures;
import net.imglib2.trainable_segmention.pixel_feature.filter.FeatureOp;
import net.imglib2.trainable_segmention.pixel_feature.settings.ChannelSetting;
import net.imglib2.trainable_segmention.pixel_feature.settings.FeatureSetting;
import net.imglib2.trainable_segmention.pixel_feature.settings.FeatureSettings;
import net.imglib2.trainable_segmention.pixel_feature.settings.GlobalSettings;
import net.miginfocom.swing.MigLayout;
import org.scijava.AbstractContextual;
import org.scijava.Context;
import org.scijava.module.Module;
import org.scijava.module.ModuleCanceledException;
import org.scijava.module.ModuleException;
import org.scijava.ui.swing.widget.SwingInputHarvester;
import org.scijava.widget.InputHarvester;

public class FeatureSettingsGui {
    private final JPanel content = new JPanel();
    private final ListModel model;
    private final JList<Holder> list = new JList();
    private final Context context;
    private final FeatureSettingsDialog featureSettingsDialog;
    private GlobalsPanel globalsPanel;

    public FeatureSettingsGui(Context context, FeatureSettings fs) {
        this.context = context;
        this.featureSettingsDialog = new FeatureSettingsDialog(this.context);
        List<Holder> init = fs.features().stream().map(f -> new Holder((FeatureSetting)f)).collect(Collectors.toList());
        this.model = new ListModel(init);
        this.initGui(fs.globals());
    }

    public JComponent getComponent() {
        return this.content;
    }

    public FeatureSettings get() {
        return new FeatureSettings(this.globalsPanel.get(), this.model.features());
    }

    private void initGui(GlobalSettings globals) {
        this.list.setModel(this.model);
        this.content.setLayout((LayoutManager)new MigLayout("insets 0", "[grow]", "[][grow][]"));
        this.globalsPanel = new GlobalsPanel(globals);
        this.content.add((Component)this.globalsPanel, "wrap");
        this.content.add((Component)new JScrollPane(this.list), "split 2, grow");
        JPopupMenu menu = this.initMenu(globals);
        JButton addButton = new JButton("add");
        addButton.addActionListener(a -> menu.show(addButton, 0, addButton.getHeight()));
        JPanel sidePanel = new JPanel();
        sidePanel.setLayout((LayoutManager)new MigLayout("insets 0", "[]", "[][][][grow]"));
        sidePanel.add((Component)addButton, "grow, wrap");
        sidePanel.add((Component)this.addButton("remove", this::removePressed), "grow, wrap");
        sidePanel.add((Component)this.addButton("edit", this::editPressed), "grow, wrap");
        this.content.add((Component)sidePanel, "top, wrap");
    }

    private JPopupMenu initMenu(GlobalSettings globals) {
        JPopupMenu menu = new JPopupMenu();
        Map<String, Class<? extends FeatureOp>> features = AvailableFeatures.getMap(this.context, globals);
        features.forEach((label, featureClass) -> {
            JMenuItem item = new JMenuItem((String)label);
            item.addActionListener(l -> this.addPressed((Class<? extends FeatureOp>)featureClass));
            menu.add(item);
        });
        return menu;
    }

    private void removePressed() {
        int index = this.list.getSelectedIndex();
        if (index < 0) {
            return;
        }
        this.model.remove(index);
        this.model.update();
    }

    private void editPressed() {
        int index = this.list.getSelectedIndex();
        if (index < 0) {
            return;
        }
        this.model.getElementAt(index).edit();
        this.model.update();
    }

    private void addPressed(Class<? extends FeatureOp> featureClass) {
        this.model.add(new Holder(featureClass));
    }

    private JButton addButton(String add, Runnable runnable) {
        JButton button = new JButton(add);
        button.addActionListener(e -> runnable.run());
        return button;
    }

    public static Optional<FeatureSettings> show(Context context, FeatureSettings fg) {
        FeatureSettingsGui featureSettingsGui = new FeatureSettingsGui(context, fg);
        return featureSettingsGui.showInternal();
    }

    private Optional<FeatureSettings> showInternal() {
        boolean ok = FeatureSettingsGui.showResizeableOkCancelDialog("Select Pixel Features", this.content);
        if (ok) {
            FeatureSettings features = this.get();
            return Optional.of(features);
        }
        return Optional.empty();
    }

    private static boolean showResizeableOkCancelDialog(String title, JPanel content) {
        JDialog dialog = new JDialog((Frame)null, title, true);
        JOptionPane optionPane = new JOptionPane(content, -1, 2);
        dialog.setContentPane(optionPane);
        dialog.setResizable(true);
        dialog.setDefaultCloseOperation(2);
        optionPane.addPropertyChangeListener(e -> {
            String prop = e.getPropertyName();
            if (dialog.isVisible() && e.getSource() == optionPane && "value".equals(prop)) {
                dialog.dispose();
            }
        });
        dialog.pack();
        dialog.setVisible(true);
        return optionPane.getValue().equals(0);
    }

    public static void main(String ... args) {
        Context context = new Context();
        System.out.println(FeatureSettingsGui.show(context, new FeatureSettings(GlobalSettings.default2dSettings(), new FeatureSetting[0])));
        System.out.println("finished");
    }

    private static class ListOfDoubleFormatter
    extends JFormattedTextField.AbstractFormatter {
        private ListOfDoubleFormatter() {
        }

        @Override
        public Object stringToValue(String text) throws ParseException {
            return Stream.of(text.split(";")).map(Double::new).collect(Collectors.toList());
        }

        @Override
        public String valueToString(Object value) throws ParseException {
            if (value == null) {
                return "";
            }
            List list = (List)value;
            StringJoiner joiner = new StringJoiner("; ");
            list.stream().map(Object::toString).forEach(joiner::add);
            return joiner.toString();
        }
    }

    static class FeatureSettingsDialog
    extends AbstractContextual {
        private final InputHarvester harvester = new SwingInputHarvester();

        FeatureSettingsDialog(Context context) {
            context.inject((Object)this.harvester);
        }

        FeatureSetting show(FeatureSetting op, GlobalSettings globalSetting) {
            try {
                Module module = op.asModule(globalSetting);
                this.harvester.harvest(module);
                return FeatureSetting.fromModule(module);
            }
            catch (ModuleCanceledException e) {
                return op;
            }
            catch (ModuleException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class ListModel
    extends AbstractListModel<Holder> {
        private final List<Holder> items;

        public ListModel(List<Holder> items) {
            this.items = new ArrayList<Holder>(items);
        }

        @Override
        public int getSize() {
            return this.items.size();
        }

        @Override
        public Holder getElementAt(int index) {
            return this.items.get(index);
        }

        public void add(Holder holder) {
            this.items.add(holder);
            this.update();
        }

        public void remove(int index) {
            this.items.remove(index);
            this.update();
        }

        public void update() {
            this.fireContentsChanged(this.items, 0, this.items.size());
        }

        public List<FeatureSetting> features() {
            return this.items.stream().map(h -> h.get()).collect(Collectors.toList());
        }
    }

    private class Holder {
        private FeatureSetting value;

        public Holder(Class<? extends FeatureOp> featureClass) {
            this.value = FeatureSetting.fromClass(featureClass);
        }

        public Holder(FeatureSetting f) {
            this.value = f;
        }

        void edit() {
            this.value = FeatureSettingsGui.this.featureSettingsDialog.show(this.value, FeatureSettingsGui.this.globalsPanel.get());
        }

        public String toString() {
            StringJoiner joiner = new StringJoiner(", ");
            for (String parameter : this.value.parameters()) {
                joiner.add(parameter + " = " + this.value.getParameter(parameter));
            }
            return this.value.getName() + " " + joiner;
        }

        public FeatureSetting get() {
            return this.value;
        }
    }

    private static class GlobalsPanel
    extends JPanel {
        private final ChannelSetting channelSetting;
        private final int numDimensions;
        private final JFormattedTextField sigmasField;
        private final JFormattedTextField thicknessField;

        public GlobalsPanel(GlobalSettings globalSettings) {
            this.channelSetting = globalSettings.channelSetting();
            this.numDimensions = globalSettings.numDimensions();
            this.setLayout((LayoutManager)new MigLayout("insets 0", "[]20pt[100pt]", "[][]"));
            this.add(new JLabel("Radii:"));
            this.sigmasField = new JFormattedTextField(new ListOfDoubleFormatter());
            this.sigmasField.setValue(globalSettings.sigmas());
            this.add((Component)this.sigmasField, "grow, wrap");
            this.add(new JLabel("Membrane Thickness:"));
            this.thicknessField = new JFormattedTextField(globalSettings.membraneThickness());
            this.add((Component)this.thicknessField, "grow, wrap");
        }

        GlobalSettings get() {
            return new GlobalSettings(this.channelSetting, this.numDimensions, (List)this.sigmasField.getValue(), (Double)this.thicknessField.getValue());
        }
    }
}

