/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.trainable_segmention.pixel_feature.calculator;

import java.util.Arrays;
import java.util.List;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.trainable_segmention.RevampUtils;
import net.imglib2.trainable_segmention.pixel_feature.calculator.InputPreprocessor;
import net.imglib2.trainable_segmention.pixel_feature.settings.GlobalSettings;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Intervals;
import net.imglib2.view.MixedTransformView;
import net.imglib2.view.Views;

public class ColorInputPreprocessor
implements InputPreprocessor {
    private final GlobalSettings globals;

    public ColorInputPreprocessor(GlobalSettings globals) {
        this.globals = globals;
    }

    @Override
    public List<RandomAccessible<FloatType>> getChannels(RandomAccessible<?> input) {
        Object element = input.randomAccess().get();
        if (element instanceof ARGBType) {
            return this.processARGBType((RandomAccessible<ARGBType>)((RandomAccessible)RevampUtils.uncheckedCast(input)));
        }
        if (element instanceof RealType) {
            return this.processRealType(RevampUtils.randomAccessibleToFloat((RandomAccessible)RevampUtils.uncheckedCast(input)));
        }
        throw new IllegalArgumentException("Input image must be RealType or ARGBType.");
    }

    private List<RandomAccessible<FloatType>> processARGBType(RandomAccessible<ARGBType> image) {
        if (image.numDimensions() != this.globals.numDimensions()) {
            throw new IllegalArgumentException("Input image must have " + this.globals.numDimensions() + " dimensions.");
        }
        return RevampUtils.splitChannels(image);
    }

    private List<RandomAccessible<FloatType>> processRealType(RandomAccessible<FloatType> image) {
        int colorAxis = this.globals.numDimensions();
        if (image.numDimensions() != colorAxis + 1) {
            throw new IllegalArgumentException("Input image must have " + this.globals.numDimensions() + " dimensions plus one color channel.");
        }
        MixedTransformView red = Views.hyperSlice(image, (int)colorAxis, (long)0L);
        MixedTransformView green = Views.hyperSlice(image, (int)colorAxis, (long)1L);
        MixedTransformView blue = Views.hyperSlice(image, (int)colorAxis, (long)2L);
        return Arrays.asList(red, green, blue);
    }

    @Override
    public Class<?> getType() {
        return ARGBType.class;
    }

    @Override
    public Interval outputIntervalFromInput(RandomAccessibleInterval<?> image) {
        Object element = image.randomAccess().get();
        if (element instanceof ARGBType) {
            return image;
        }
        if (element instanceof RealType) {
            return this.outputIntervalFromInputRealType(image);
        }
        return null;
    }

    private Interval outputIntervalFromInputRealType(RandomAccessibleInterval<?> image) {
        int colorAxis = this.globals.numDimensions();
        if (image.numDimensions() != colorAxis + 1) {
            throw new IllegalArgumentException("Input image must have " + this.globals.numDimensions() + " dimensions plus one color channel.");
        }
        if (image.dimension(colorAxis) != 3L) {
            throw new IllegalArgumentException("Input image must contain three color channels.");
        }
        return new FinalInterval(Arrays.copyOf(Intervals.minAsLongArray(image), colorAxis), Arrays.copyOf(Intervals.maxAsLongArray(image), colorAxis));
    }
}

