/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.trainable_segmention.pixel_feature.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.imagej.ops.OpEnvironment;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.trainable_segmention.pixel_feature.filter.FeatureOp;
import net.imglib2.trainable_segmention.pixel_feature.settings.GlobalSettings;
import net.imglib2.type.numeric.real.FloatType;

public class FeatureJoiner {
    private final GlobalSettings settings;
    private final OpEnvironment ops;
    private final List<FeatureOp> features;
    private final int count;

    public FeatureJoiner(List<FeatureOp> features) {
        this.settings = this.checkGlobalSettings(features);
        this.ops = this.checkOps(features);
        this.features = features;
        this.count = this.features.stream().mapToInt(FeatureOp::count).sum();
    }

    private GlobalSettings checkGlobalSettings(List<FeatureOp> features) {
        if (features.isEmpty()) {
            return null;
        }
        GlobalSettings settings = features.get(0).globalSettings();
        boolean allEqual = features.stream().allMatch(f -> settings.equals(f.globalSettings()));
        if (!allEqual) {
            throw new IllegalArgumentException("All features in a feature group must use the same global settings");
        }
        return settings;
    }

    private OpEnvironment checkOps(List<FeatureOp> features) {
        if (features.isEmpty()) {
            return null;
        }
        return features.get(0).ops();
    }

    public GlobalSettings globalSettings() {
        return this.settings;
    }

    public int count() {
        return this.count;
    }

    public void apply(RandomAccessible<FloatType> in, List<RandomAccessibleInterval<FloatType>> out) {
        if (out.size() != this.count) {
            throw new IllegalArgumentException();
        }
        int startIndex = 0;
        for (FeatureOp feature : this.features) {
            int count = feature.count();
            feature.apply(in, out.subList(startIndex, startIndex + count));
            startIndex += count;
        }
    }

    public List<String> attributeLabels() {
        ArrayList<String> labels = new ArrayList<String>();
        this.features.stream().map(FeatureOp::attributeLabels).forEach(labels::addAll);
        return labels;
    }

    public List<FeatureOp> features() {
        return Collections.unmodifiableList(this.features);
    }

    public OpEnvironment ops() {
        return this.ops;
    }
}

