/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.trainable_segmention.pixel_feature.filter;

import net.imglib2.trainable_segmention.pixel_feature.filter.FeatureOp;
import net.imglib2.trainable_segmention.pixel_feature.filter.dog.DifferenceOfGaussiansFeature;
import net.imglib2.trainable_segmention.pixel_feature.filter.gabor.GaborFeature;
import net.imglib2.trainable_segmention.pixel_feature.filter.gauss.GaussFeature;
import net.imglib2.trainable_segmention.pixel_feature.filter.gradient.GradientFeature;
import net.imglib2.trainable_segmention.pixel_feature.filter.gradient.SobelGradientFeature;
import net.imglib2.trainable_segmention.pixel_feature.filter.hessian.Hessian3DFeature;
import net.imglib2.trainable_segmention.pixel_feature.filter.hessian.HessianFeature;
import net.imglib2.trainable_segmention.pixel_feature.filter.lipschitz.LipschitzFeature;
import net.imglib2.trainable_segmention.pixel_feature.filter.stats.SphereShapedFeature;
import net.imglib2.trainable_segmention.pixel_feature.settings.FeatureSetting;

public class GroupedFeatures {
    public static FeatureSetting gabor() {
        return GroupedFeatures.createFeature(GaborFeature.class, "legacyNormalize", Boolean.FALSE);
    }

    public static FeatureSetting legacyGabor() {
        return GroupedFeatures.createFeature(GaborFeature.class, "legacyNormalize", Boolean.TRUE);
    }

    public static FeatureSetting gauss() {
        return GroupedFeatures.createFeature(GaussFeature.class, new Object[0]);
    }

    public static FeatureSetting sobelGradient() {
        return GroupedFeatures.createFeature(SobelGradientFeature.class, new Object[0]);
    }

    public static FeatureSetting gradient() {
        return GroupedFeatures.createFeature(GradientFeature.class, new Object[0]);
    }

    public static FeatureSetting min() {
        return GroupedFeatures.createSphereShapeFeature("Minimum");
    }

    public static FeatureSetting max() {
        return GroupedFeatures.createSphereShapeFeature("Maximum");
    }

    public static FeatureSetting mean() {
        return GroupedFeatures.createSphereShapeFeature("Mean");
    }

    public static FeatureSetting median() {
        return GroupedFeatures.createSphereShapeFeature("Median");
    }

    public static FeatureSetting variance() {
        return GroupedFeatures.createSphereShapeFeature("Variance");
    }

    private static FeatureSetting createSphereShapeFeature(String operation) {
        return GroupedFeatures.createFeature(SphereShapedFeature.class, "operation", operation);
    }

    public static FeatureSetting lipschitz(long border) {
        return GroupedFeatures.createFeature(LipschitzFeature.class, "border", border);
    }

    public static FeatureSetting hessian() {
        return GroupedFeatures.createFeature(HessianFeature.class, new Object[0]);
    }

    public static FeatureSetting differenceOfGaussians() {
        return GroupedFeatures.createFeature(DifferenceOfGaussiansFeature.class, new Object[0]);
    }

    public static FeatureSetting hessian3D(boolean absoluteValues) {
        return GroupedFeatures.createFeature(Hessian3DFeature.class, "absoluteValues", absoluteValues);
    }

    private static FeatureSetting createFeature(Class<? extends FeatureOp> aClass, Object ... args) {
        return new FeatureSetting(aClass, args);
    }
}

