/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.trainable_segmention.pixel_feature.filter;

import net.imglib2.trainable_segmention.pixel_feature.filter.FeatureOp;
import net.imglib2.trainable_segmention.pixel_feature.filter.dog.SingleDifferenceOfGaussiansFeature;
import net.imglib2.trainable_segmention.pixel_feature.filter.gabor.SingleGaborFeature;
import net.imglib2.trainable_segmention.pixel_feature.filter.gauss.SingleGaussFeature;
import net.imglib2.trainable_segmention.pixel_feature.filter.gradient.SingleGradientFeature;
import net.imglib2.trainable_segmention.pixel_feature.filter.gradient.SingleSobelGradientFeature;
import net.imglib2.trainable_segmention.pixel_feature.filter.hessian.SingleHessian3DFeature;
import net.imglib2.trainable_segmention.pixel_feature.filter.hessian.SingleHessianFeature;
import net.imglib2.trainable_segmention.pixel_feature.filter.identity.IdendityFeature;
import net.imglib2.trainable_segmention.pixel_feature.filter.lipschitz.SingleLipschitzFeature;
import net.imglib2.trainable_segmention.pixel_feature.filter.stats.SingleSphereShapedFeature;
import net.imglib2.trainable_segmention.pixel_feature.settings.FeatureSetting;

public class SingleFeatures {
    public static FeatureSetting identity() {
        return SingleFeatures.createFeature(IdendityFeature.class, new Object[0]);
    }

    public static FeatureSetting gabor(double sigma, double gamma, double psi, double frequency, int nAngles) {
        return SingleFeatures.gabor(sigma, gamma, psi, frequency, nAngles, false);
    }

    public static FeatureSetting legacyGabor(double sigma, double gamma, double psi, double frequency, int nAngles) {
        return SingleFeatures.gabor(sigma, gamma, psi, frequency, nAngles, true);
    }

    private static FeatureSetting gabor(double sigma, double gamma, double psi, double frequency, int nAngles, boolean legacyNormalize) {
        return SingleFeatures.createFeature(SingleGaborFeature.class, "sigma", sigma, "gamma", gamma, "psi", psi, "frequency", frequency, "nAngles", nAngles, "legacyNormalize", legacyNormalize);
    }

    public static FeatureSetting gauss(double sigma) {
        return SingleFeatures.createFeature(SingleGaussFeature.class, "sigma", sigma);
    }

    public static FeatureSetting sobelGradient(double sigma) {
        return SingleFeatures.createFeature(SingleSobelGradientFeature.class, "sigma", sigma);
    }

    public static FeatureSetting gradient(double sigma) {
        return SingleFeatures.createFeature(SingleGradientFeature.class, "sigma", sigma);
    }

    public static FeatureSetting lipschitz(double slope, long border) {
        return SingleFeatures.createFeature(SingleLipschitzFeature.class, "slope", slope, "border", border);
    }

    public static FeatureSetting hessian(double sigma) {
        return SingleFeatures.createFeature(SingleHessianFeature.class, "sigma", sigma);
    }

    public static FeatureSetting differenceOfGaussians(double sigma1, double sigma2) {
        return SingleFeatures.createFeature(SingleDifferenceOfGaussiansFeature.class, "sigma1", sigma1, "sigma2", sigma2);
    }

    public static FeatureSetting sphereOperation(double radius, String operation) {
        return SingleFeatures.createFeature(SingleSphereShapedFeature.class, "radius", radius, "operation", operation);
    }

    public static FeatureSetting hessian3d(double sigma, boolean absoluteValues) {
        return SingleFeatures.createFeature(SingleHessian3DFeature.class, "sigma", sigma, "absoluteValues", absoluteValues);
    }

    private static FeatureSetting createFeature(Class<? extends FeatureOp> aClass, Object ... args) {
        return new FeatureSetting(aClass, args);
    }
}

