/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.trainable_segmention.pixel_feature.filter.dog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.gauss3.Gauss3;
import net.imglib2.img.Img;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.trainable_segmention.RevampUtils;
import net.imglib2.trainable_segmention.pixel_feature.filter.AbstractFeatureOp;
import net.imglib2.trainable_segmention.pixel_feature.filter.FeatureOp;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;
import org.scijava.plugin.Plugin;

@Plugin(type=FeatureOp.class, label="Difference of Gaussians (Group)")
public class DifferenceOfGaussiansFeature
extends AbstractFeatureOp {
    private List<Double> sigmas;
    private List<Pair<Double, Double>> sigmaPairs;

    private List<Pair<Double, Double>> sigmaPairs() {
        ArrayList<Pair<Double, Double>> sigmaPairs = new ArrayList<Pair<Double, Double>>();
        for (double sigma1 : this.sigmas) {
            for (double sigma2 : this.sigmas) {
                if (!(sigma2 < sigma1)) continue;
                sigmaPairs.add((Pair<Double, Double>)new ValuePair((Object)sigma1, (Object)sigma2));
            }
        }
        return sigmaPairs;
    }

    public void initialize() {
        this.sigmas = this.globalSettings().sigmas();
        this.sigmaPairs = this.sigmaPairs();
    }

    @Override
    public int count() {
        return this.sigmaPairs.size();
    }

    @Override
    public List<String> attributeLabels() {
        return this.sigmaPairs.stream().map(pair -> "Difference_of_gaussians_" + pair.getA() + "_" + pair.getB()).collect(Collectors.toList());
    }

    @Override
    public void apply(RandomAccessible<FloatType> input, List<RandomAccessibleInterval<FloatType>> output) {
        FinalInterval interval = new FinalInterval((Interval)output.get(0));
        Map<Double, RandomAccessibleInterval<FloatType>> gausses = this.calculateGausses(input, (Interval)interval);
        this.calculateDifferences(gausses, output);
    }

    private void calculateDifferences(Map<Double, RandomAccessibleInterval<FloatType>> gausses, List<RandomAccessibleInterval<FloatType>> output) {
        for (int i = 0; i < output.size(); ++i) {
            Pair<Double, Double> sigma1and2 = this.sigmaPairs.get(i);
            RandomAccessibleInterval<FloatType> target = output.get(i);
            DifferenceOfGaussiansFeature.subtract(gausses.get(sigma1and2.getB()), gausses.get(sigma1and2.getA()), target);
        }
    }

    private Map<Double, RandomAccessibleInterval<FloatType>> calculateGausses(RandomAccessible<FloatType> input, Interval interval) {
        HashMap<Double, RandomAccessibleInterval<FloatType>> gausses = new HashMap<Double, RandomAccessibleInterval<FloatType>>();
        for (double sigma : this.sigmas) {
            gausses.put(sigma, this.gauss(input, interval, sigma));
        }
        return gausses;
    }

    private static void subtract(RandomAccessibleInterval<FloatType> minuend, RandomAccessibleInterval<FloatType> subtrahend, RandomAccessibleInterval<FloatType> target) {
        LoopBuilder.setImages(minuend, subtrahend, target).forEachPixel((m, s, t) -> t.setReal(m.getRealFloat() - s.getRealFloat()));
    }

    private RandomAccessibleInterval<FloatType> gauss(RandomAccessible<FloatType> input, Interval interval, double sigma) {
        Img result = this.ops().create().img((Dimensions)interval, (NativeType)new FloatType());
        RevampUtils.wrapException(() -> Gauss3.gauss((double)(sigma * 0.4), (RandomAccessible)input, (RandomAccessibleInterval)result));
        return result;
    }
}

