/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.trainable_segmention.pixel_feature.filter.dog;

import java.util.Collections;
import java.util.List;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.gauss3.Gauss3;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.trainable_segmention.pixel_feature.filter.AbstractFeatureOp;
import net.imglib2.trainable_segmention.pixel_feature.filter.FeatureOp;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.Views;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=FeatureOp.class, label="Difference of Gaussians")
public class SingleDifferenceOfGaussiansFeature
extends AbstractFeatureOp {
    @Parameter
    private double sigma1 = 2.0;
    @Parameter
    private double sigma2 = 4.0;

    @Override
    public int count() {
        return 1;
    }

    @Override
    public void apply(RandomAccessible<FloatType> in, List<RandomAccessibleInterval<FloatType>> out) {
        this.dog(in, out.get(0));
    }

    @Override
    public List<String> attributeLabels() {
        return Collections.singletonList("Difference_of_gaussians_" + this.sigma1 + "_" + this.sigma2);
    }

    private void dog(RandomAccessible<FloatType> in, RandomAccessibleInterval<FloatType> out) {
        try {
            Img tmp = this.ops().create().img(out);
            Gauss3.gauss((double)(this.sigma1 * 0.4), in, (RandomAccessibleInterval)tmp);
            Gauss3.gauss((double)(this.sigma2 * 0.4), in, out);
            Views.interval((RandomAccessible)Views.pair((RandomAccessible)tmp, out), out).forEach(p -> ((FloatType)p.getB()).sub((FloatType)p.getA()));
        }
        catch (IncompatibleTypeException e) {
            throw new RuntimeException(e);
        }
    }
}

