/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.trainable_segmention.pixel_feature.filter.gauss;

import java.util.Collections;
import java.util.List;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.gauss3.Gauss3;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.trainable_segmention.pixel_feature.filter.AbstractFeatureOp;
import net.imglib2.trainable_segmention.pixel_feature.filter.FeatureOp;
import net.imglib2.type.numeric.real.FloatType;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=FeatureOp.class, label="Gauss")
public class SingleGaussFeature
extends AbstractFeatureOp {
    @Parameter
    private double sigma = 1.0;

    @Override
    public int count() {
        return 1;
    }

    @Override
    public List<String> attributeLabels() {
        return Collections.singletonList("Gaussian_blur_" + this.sigma);
    }

    @Override
    public void apply(RandomAccessible<FloatType> input, List<RandomAccessibleInterval<FloatType>> output) {
        try {
            Gauss3.gauss((double)(this.sigma * 0.4), input, output.get(0));
        }
        catch (IncompatibleTypeException e) {
            throw new RuntimeException(e);
        }
    }
}

