/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.trainable_segmention.pixel_feature.filter.gradient;

import java.util.Collections;
import java.util.List;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.gauss3.Gauss3;
import net.imglib2.algorithm.gradient.PartialDerivative;
import net.imglib2.converter.Converters;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.trainable_segmention.RevampUtils;
import net.imglib2.trainable_segmention.pixel_feature.filter.AbstractFeatureOp;
import net.imglib2.trainable_segmention.pixel_feature.filter.FeatureOp;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.type.operators.SetZero;
import net.imglib2.util.Intervals;
import net.imglib2.view.Views;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=FeatureOp.class, label="Gradient")
public class SingleGradientFeature
extends AbstractFeatureOp {
    @Parameter
    private double sigma;

    @Override
    public int count() {
        return 1;
    }

    @Override
    public void apply(RandomAccessible<FloatType> in, List<RandomAccessibleInterval<FloatType>> out) {
        this.calculate(in, out.get(0));
    }

    @Override
    public List<String> attributeLabels() {
        return Collections.singletonList("Gradient_filter_" + this.sigma);
    }

    private void calculate(RandomAccessible<FloatType> in, RandomAccessibleInterval<FloatType> out) {
        int numDimensions = out.numDimensions();
        FinalInterval expand = Intervals.expand(out, (long[])RevampUtils.nCopies(numDimensions, 1L));
        RandomAccessibleInterval<FloatType> blurred = this.gauss(in, (Interval)expand, 0.4 * this.sigma);
        Img derivative = this.ops().create().img(out);
        this.setZero(out);
        for (int d = 0; d < numDimensions; ++d) {
            PartialDerivative.gradientCentralDifference2(blurred, (RandomAccessibleInterval)derivative, (int)d);
            this.add(out, (RandomAccessible<FloatType>)this.squared((RandomAccessibleInterval<FloatType>)derivative));
        }
        Views.iterable(out).forEach(x -> x.set((float)Math.sqrt(x.get())));
    }

    private RandomAccessibleInterval<FloatType> gauss(RandomAccessible<FloatType> in, Interval outputInterval, double sigma) {
        Img blurred = this.ops().create().img((Dimensions)outputInterval, (NativeType)new FloatType());
        try {
            Gauss3.gauss((double)sigma, in, (RandomAccessibleInterval)blurred);
        }
        catch (IncompatibleTypeException e) {
            throw new RuntimeException(e);
        }
        return blurred;
    }

    private void setZero(RandomAccessibleInterval<? extends SetZero> out) {
        Views.iterable(out).forEach(SetZero::setZero);
    }

    private RandomAccessibleInterval<FloatType> squared(RandomAccessibleInterval<FloatType> derivate) {
        return Converters.convert(derivate, (i, o) -> {
            o.set(i);
            o.mul(i);
        }, (Type)new FloatType());
    }

    private void add(RandomAccessibleInterval<FloatType> out, RandomAccessible<FloatType> in) {
        Views.interval((RandomAccessible)Views.pair(out, in), out).forEach(p -> ((FloatType)p.getA()).add((FloatType)p.getB()));
    }
}

