/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.trainable_segmention.pixel_feature.filter.gradient;

import java.util.Collections;
import java.util.List;
import java.util.function.ToDoubleFunction;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.trainable_segmention.RevampUtils;
import net.imglib2.trainable_segmention.pixel_feature.filter.AbstractFeatureOp;
import net.imglib2.trainable_segmention.pixel_feature.filter.FeatureOp;
import net.imglib2.trainable_segmention.pixel_feature.settings.GlobalSettings;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Intervals;
import net.imglib2.view.Views;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=FeatureOp.class, label="Sobel Gradient")
public class SingleSobelGradientFeature
extends AbstractFeatureOp {
    @Parameter
    private double sigma;

    @Override
    public int count() {
        return 1;
    }

    @Override
    public void apply(RandomAccessible<FloatType> in, List<RandomAccessibleInterval<FloatType>> out) {
        this.calculate(in, out.get(0));
    }

    @Override
    public List<String> attributeLabels() {
        return Collections.singletonList("Sobel_filter_" + this.sigma);
    }

    @Override
    public boolean checkGlobalSettings(GlobalSettings globals) {
        return globals.numDimensions() == 2;
    }

    private void calculate(RandomAccessible<FloatType> in, RandomAccessibleInterval<FloatType> out) {
        double[] sigmas = new double[]{0.4 * this.sigma, 0.4 * this.sigma};
        Interval dxInputInterval = RevampUtils.deriveXRequiredInput(out);
        Interval dyInputInterval = RevampUtils.deriveYRequiredInput(out);
        FinalInterval blurredInterval = Intervals.union((Interval)dxInputInterval, (Interval)dyInputInterval);
        RandomAccessibleInterval<FloatType> blurred = RevampUtils.gauss(this.ops(), in, (Interval)blurredInterval, sigmas);
        RandomAccessibleInterval<FloatType> dx = RevampUtils.deriveX(this.ops(), blurred, out);
        RandomAccessibleInterval<FloatType> dy = RevampUtils.deriveY(this.ops(), blurred, out);
        RandomAccessible derivatives = Views.pair(dx, dy);
        this.mapToFloat(derivatives, out, input -> SingleSobelGradientFeature.norm2(((FloatType)input.getA()).get(), ((FloatType)input.getB()).get()));
    }

    private <I> void mapToFloat(RandomAccessible<I> in, RandomAccessibleInterval<FloatType> out, ToDoubleFunction<I> operation) {
        Views.interval((RandomAccessible)Views.pair(in, out), out).forEach(p -> ((FloatType)p.getB()).set((float)operation.applyAsDouble(p.getA())));
    }

    private static double norm2(float x, float y) {
        return Math.sqrt(x * x + y * y);
    }
}

