/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.trainable_segmention.pixel_feature.filter.hessian;

public class EigenValues {
    private static final double TWOPI = Math.PI * 2;

    public static void eigenvalues(Vector3D v, double a11, double a12, double a13, double a22, double a23, double a33) {
        double a = -(a11 + a22 + a33);
        double b = a11 * a22 + a11 * a33 + a22 * a33 - a12 * a12 - a13 * a13 - a23 * a23;
        double c = a11 * (a23 * a23 - a22 * a33) + a22 * a13 * a13 + a33 * a12 * a12 - 2.0 * a12 * a13 * a23;
        double q = (a * a - 3.0 * b) / 9.0;
        double r = (a * a * a - 4.5 * a * b + 13.5 * c) / 27.0;
        double sqrtq = q > 0.0 ? Math.sqrt(q) : 0.0;
        double sqrtq3 = sqrtq * sqrtq * sqrtq;
        if (sqrtq3 == 0.0) {
            v.x = 0.0;
            v.y = 0.0;
            v.z = 0.0;
        } else {
            double rsqq3 = r / sqrtq3;
            double angle = rsqq3 * rsqq3 <= 1.0 ? Math.acos(rsqq3) : Math.acos(rsqq3 < 0.0 ? -1.0 : 1.0);
            v.x = -2.0 * sqrtq * Math.cos(angle / 3.0) - a / 3.0;
            v.y = -2.0 * sqrtq * Math.cos((angle + Math.PI * 2) / 3.0) - a / 3.0;
            v.z = -2.0 * sqrtq * Math.cos((angle - Math.PI * 2) / 3.0) - a / 3.0;
        }
    }

    public static void abs(Vector3D v) {
        v.x = Math.abs(v.x);
        v.y = Math.abs(v.y);
        v.z = Math.abs(v.z);
    }

    public static void sort(Vector3D v) {
        double tmp;
        if (v.x < v.y) {
            tmp = v.x;
            v.x = v.y;
            v.y = tmp;
        }
        if (v.y < v.z) {
            tmp = v.y;
            v.y = v.z;
            v.z = tmp;
            if (v.x < v.z) {
                double tmp2 = v.x;
                v.x = v.z;
                v.z = tmp2;
            }
        }
    }

    public static class Vector3D {
        public double x;
        public double y;
        public double z;

        public String toString() {
            return this.x + ", " + this.y + ", " + this.z;
        }
    }
}

