/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.trainable_segmention.pixel_feature.filter.hessian;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.trainable_segmention.RevampUtils;
import net.imglib2.trainable_segmention.pixel_feature.filter.AbstractFeatureOp;
import net.imglib2.trainable_segmention.pixel_feature.filter.FeatureOp;
import net.imglib2.trainable_segmention.pixel_feature.settings.GlobalSettings;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Intervals;
import net.imglib2.view.Views;
import net.imglib2.view.composite.RealComposite;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=FeatureOp.class, label="Hessian")
public class SingleHessianFeature
extends AbstractFeatureOp {
    @Parameter
    private double sigma = 1.0;
    List<String> LABELS = Arrays.asList("", "_Trace", "_Determinant", "_Eigenvalue_1", "_Eigenvalue_2", "_Orientation", "_Square_Eigenvalue_Difference", "_Normalized_Eigenvalue_Difference");
    private static final int HESSIAN = 0;
    private static final int TRACE = 1;
    private static final int DETERMINANT = 2;
    private static final int EIGENVALUE_1 = 3;
    private static final int EIGENVALUE_2 = 4;
    private static final int ORIENTATION = 5;
    private static final int SQUARE_EIGENVALUE_DIFFERENCE = 6;
    private static final int NORMALIZED_EIGENVALUE_DIFFERENCE = 7;

    @Override
    public int count() {
        return 8;
    }

    @Override
    public void apply(RandomAccessible<FloatType> in, List<RandomAccessibleInterval<FloatType>> out) {
        RandomAccessibleInterval features = Views.stack(out);
        this.calculateHessianOnChannel(in, (RandomAccessibleInterval<FloatType>)features, this.sigma);
    }

    @Override
    public List<String> attributeLabels() {
        return this.LABELS.stream().map(x -> "Hessian" + x + "_" + this.sigma).collect(Collectors.toList());
    }

    @Override
    public boolean checkGlobalSettings(GlobalSettings globals) {
        return globals.numDimensions() == 2;
    }

    public RandomAccessibleInterval<FloatType> calculateHessianOnChannel(Img<FloatType> image, double sigma) {
        Img features = this.ops().create().img((Dimensions)RevampUtils.appendDimensionToInterval(image, 0L, 7L), (NativeType)new FloatType());
        this.calculateHessianOnChannel((RandomAccessible<FloatType>)Views.extendBorder(image), (RandomAccessibleInterval<FloatType>)features, sigma);
        return features;
    }

    private void calculateHessianOnChannel(RandomAccessible<FloatType> image, RandomAccessibleInterval<FloatType> out, double sigma) {
        double[] sigmas = new double[]{0.4 * sigma, 0.4 * sigma};
        Interval secondDerivativeInterval = RevampUtils.removeLastDimension(out);
        FinalInterval firstDerivativeInterval = Intervals.union((Interval)RevampUtils.deriveXRequiredInput(secondDerivativeInterval), (Interval)RevampUtils.deriveYRequiredInput(secondDerivativeInterval));
        FinalInterval blurredInterval = Intervals.union((Interval)RevampUtils.deriveXRequiredInput((Interval)firstDerivativeInterval), (Interval)RevampUtils.deriveYRequiredInput((Interval)firstDerivativeInterval));
        RandomAccessibleInterval<FloatType> blurred = RevampUtils.gauss(this.ops(), image, (Interval)blurredInterval, sigmas);
        RandomAccessibleInterval<FloatType> dx = RevampUtils.deriveX(this.ops(), blurred, (Interval)firstDerivativeInterval);
        RandomAccessibleInterval<FloatType> dy = RevampUtils.deriveY(this.ops(), blurred, (Interval)firstDerivativeInterval);
        RandomAccess dxx = RevampUtils.deriveX(this.ops(), dx, secondDerivativeInterval).randomAccess();
        RandomAccess dxy = RevampUtils.deriveY(this.ops(), dx, secondDerivativeInterval).randomAccess();
        RandomAccess dyy = RevampUtils.deriveY(this.ops(), dy, secondDerivativeInterval).randomAccess();
        Cursor cursor = Views.iterable((RandomAccessibleInterval)Views.collapseReal(out)).cursor();
        while (cursor.hasNext()) {
            cursor.next();
            dxx.setPosition((Localizable)cursor);
            dxy.setPosition((Localizable)cursor);
            dyy.setPosition((Localizable)cursor);
            float s_xx = ((FloatType)dxx.get()).get();
            float s_xy = ((FloatType)dxy.get()).get();
            float s_yy = ((FloatType)dyy.get()).get();
            SingleHessianFeature.calculateHessianPerPixel((RealComposite<FloatType>)((RealComposite)cursor.get()), s_xx, s_xy, s_yy);
        }
    }

    private static void calculateHessianPerPixel(RealComposite<FloatType> output, float s_xx, float s_xy, float s_yy) {
        double t = Math.pow(1.0, 0.75);
        ((FloatType)output.get(0L)).set((float)Math.sqrt(s_xx * s_xx + s_xy * s_xy + s_yy * s_yy));
        float trace = s_xx + s_yy;
        ((FloatType)output.get(1L)).set(trace);
        float determinant = s_xx * s_yy - s_xy * s_xy;
        ((FloatType)output.get(2L)).set(determinant);
        ((FloatType)output.get(3L)).set((float)((double)trace / 2.0 + Math.sqrt((double)(4.0f * s_xy * s_xy + (s_xx - s_yy) * (s_xx - s_yy)) / 2.0)));
        ((FloatType)output.get(4L)).set((float)((double)trace / 2.0 - Math.sqrt((double)(4.0f * s_xy * s_xy + (s_xx - s_yy) * (s_xx - s_yy)) / 2.0)));
        if ((double)s_xy < 0.0) {
            float orientation = (float)(-0.5 * Math.acos((double)(s_xx - s_yy) / Math.sqrt(4.0 * (double)s_xy * (double)s_xy + (double)((s_xx - s_yy) * (s_xx - s_yy)))));
            if (Float.isNaN(orientation)) {
                orientation = 0.0f;
            }
            ((FloatType)output.get(5L)).set(orientation);
        } else {
            float orientation = (float)(0.5 * Math.acos((double)(s_xx - s_yy) / Math.sqrt(4.0 * (double)s_xy * (double)s_xy + (double)((s_xx - s_yy) * (s_xx - s_yy)))));
            if (Float.isNaN(orientation)) {
                orientation = 0.0f;
            }
            ((FloatType)output.get(5L)).set(orientation);
        }
        ((FloatType)output.get(6L)).set((float)(Math.pow(t, 4.0) * (double)trace * (double)trace * (double)((s_xx - s_yy) * (s_xx - s_yy) + 4.0f * s_xy * s_xy)));
        ((FloatType)output.get(7L)).set((float)(Math.pow(t, 2.0) * (double)((s_xx - s_yy) * (s_xx - s_yy) + 4.0f * s_xy * s_xy)));
    }
}

