/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.trainable_segmention.pixel_feature.filter.lipschitz;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.imglib2.trainable_segmention.pixel_feature.filter.AbstractGroupFeatureOp;
import net.imglib2.trainable_segmention.pixel_feature.filter.FeatureOp;
import net.imglib2.trainable_segmention.pixel_feature.filter.SingleFeatures;
import net.imglib2.trainable_segmention.pixel_feature.settings.FeatureSetting;
import net.imglib2.trainable_segmention.pixel_feature.settings.GlobalSettings;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=FeatureOp.class, label="Lipschitz (Group)")
public class LipschitzFeature
extends AbstractGroupFeatureOp {
    @Parameter
    private long border;

    @Override
    public boolean checkGlobalSettings(GlobalSettings globals) {
        return globals.numDimensions() == 2;
    }

    @Override
    protected List<FeatureSetting> initFeatures() {
        return Arrays.stream(new double[]{5.0, 10.0, 15.0, 20.0, 25.0}).mapToObj(slope -> SingleFeatures.lipschitz(slope, this.border)).collect(Collectors.toList());
    }
}

