/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.trainable_segmention.pixel_feature.filter.lipschitz;

import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.Point;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.trainable_segmention.RevampUtils;
import net.imglib2.trainable_segmention.pixel_feature.filter.AbstractFeatureOp;
import net.imglib2.trainable_segmention.pixel_feature.filter.FeatureOp;
import net.imglib2.trainable_segmention.pixel_feature.settings.GlobalSettings;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Intervals;
import net.imglib2.view.Views;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=FeatureOp.class, label="Lipschitz")
public class SingleLipschitzFeature
extends AbstractFeatureOp {
    @Parameter
    private double slope;
    @Parameter
    private long border;

    public SingleLipschitzFeature() {
    }

    public SingleLipschitzFeature(double slope, long border) {
        this.slope = slope;
        this.border = border;
    }

    @Override
    public int count() {
        return 1;
    }

    @Override
    public void apply(RandomAccessible<FloatType> in, List<RandomAccessibleInterval<FloatType>> out) {
        this.apply(in, out.get(0));
    }

    @Override
    public boolean checkGlobalSettings(GlobalSettings globals) {
        return globals.numDimensions() == 2;
    }

    private void apply(RandomAccessible<FloatType> in, RandomAccessibleInterval<FloatType> out) {
        FinalInterval expandedInterval = Intervals.expand(out, (long[])RevampUtils.nCopies(out.numDimensions(), this.border));
        Img tmp = this.ops().create().img((Dimensions)expandedInterval, (NativeType)new FloatType());
        this.copy((IterableInterval)tmp, (RandomAccessible)in);
        this.lipschitz((RandomAccessibleInterval)tmp);
        this.outEquals255PlusAMinusB((IterableInterval)Views.iterable(out), (RandomAccessible)in, (RandomAccessible)tmp);
    }

    private <T extends Type<T>> void copy(IterableInterval<T> out, RandomAccessible<T> in) {
        Cursor o = out.cursor();
        RandomAccess a = in.randomAccess();
        while (o.hasNext()) {
            o.fwd();
            a.setPosition((Localizable)o);
            ((Type)o.get()).set((Type)a.get());
        }
    }

    private <T extends RealType<T>> void outEquals255PlusAMinusB(IterableInterval<T> out, RandomAccessible<T> A, RandomAccessible<T> B) {
        Cursor o = out.cursor();
        RandomAccess a = A.randomAccess();
        RandomAccess b = B.randomAccess();
        RealType offset = (RealType)((RealType)a.get()).createVariable();
        offset.setReal(255.0f);
        while (o.hasNext()) {
            o.fwd();
            a.setPosition((Localizable)o);
            b.setPosition((Localizable)o);
            RealType ov = (RealType)o.get();
            ov.set((Type)offset);
            ov.sub(b.get());
            ov.add(a.get());
        }
    }

    @Override
    public List<String> attributeLabels() {
        return Collections.singletonList("Lipschitz_true_true_" + this.slope);
    }

    <T extends RealType<T>> void lipschitz(RandomAccessibleInterval<T> inOut) {
        int n = inOut.numDimensions();
        for (Localizable location : RevampUtils.neigborsLocations(n)) {
            if (this.isZero(location)) continue;
            this.forward((RandomAccessible<T>)Views.extendBorder(inOut), inOut, this.locationToArray(location));
        }
    }

    <T extends RealType<T>> void forward(RandomAccessible<T> in, RandomAccessibleInterval<T> out, long[] translation) {
        double slope = RevampUtils.distance((Localizable)new Point(out.numDimensions()), (Localizable)Point.wrap((long[])translation)) * this.slope;
        RandomAccessibleInterval<T> pair = this.invert((RandomAccessibleInterval<T>)Views.interval((RandomAccessible)Views.pair((RandomAccessible)Views.translate(in, (long[])translation), out), out), translation);
        Views.flatIterable(pair).forEach(p -> ((RealType)p.getB()).setReal(Math.max(((RealType)p.getB()).getRealDouble(), ((RealType)p.getA()).getRealDouble() - slope)));
    }

    private boolean isZero(Localizable location) {
        return this.locationToStream(location).allMatch(x -> x == 0L);
    }

    private long[] locationToArray(Localizable cursor) {
        return this.locationToStream(cursor).toArray();
    }

    private LongStream locationToStream(Localizable cursor) {
        return IntStream.range(0, cursor.numDimensions()).mapToLong(arg_0 -> ((Localizable)cursor).getLongPosition(arg_0));
    }

    private <T> RandomAccessibleInterval<T> invert(RandomAccessibleInterval<T> pair, long[] translation) {
        for (int i = pair.numDimensions() - 1; i >= 0; --i) {
            if (translation[i] >= 0L) continue;
            return Views.invertAxis(pair, (int)i);
        }
        return pair;
    }
}

