/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.trainable_segmention.pixel_feature.settings;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.imglib2.trainable_segmention.pixel_feature.settings.FeatureSetting;
import net.imglib2.trainable_segmention.pixel_feature.settings.GlobalSettings;

public class FeatureSettings {
    private final GlobalSettings globalSettings;
    private final List<FeatureSetting> featureSettingList;

    public FeatureSettings(GlobalSettings globalSettings, FeatureSetting ... featureSetting) {
        this(globalSettings, Arrays.asList(featureSetting));
    }

    public FeatureSettings(GlobalSettings globalSettings, List<FeatureSetting> featureSettingList) {
        this.globalSettings = new GlobalSettings(globalSettings);
        this.featureSettingList = featureSettingList.stream().map(FeatureSetting::new).collect(Collectors.toList());
    }

    public GlobalSettings globals() {
        return this.globalSettings;
    }

    public List<FeatureSetting> features() {
        return this.featureSettingList;
    }

    public JsonElement toJson() {
        JsonObject object = new JsonObject();
        object.add("globals", new Gson().toJsonTree((Object)this.globalSettings));
        object.add("ops", FeatureSettings.serialize(this.featureSettingList));
        return object;
    }

    public static FeatureSettings fromJson(JsonElement json) {
        JsonObject object = json.getAsJsonObject();
        GlobalSettings globalSettings = (GlobalSettings)new Gson().fromJson(object.get("globals"), GlobalSettings.class);
        List<FeatureSetting> features = FeatureSettings.deserializeFeatureSettingsList(object.get("ops").getAsJsonArray());
        return new FeatureSettings(globalSettings, features);
    }

    private static JsonElement serialize(List<FeatureSetting> features) {
        JsonArray array = new JsonArray();
        features.forEach(feature -> array.add(feature.toJsonTree()));
        return array;
    }

    private static List<FeatureSetting> deserializeFeatureSettingsList(JsonArray ops) {
        ArrayList<FeatureSetting> features = new ArrayList<FeatureSetting>();
        ops.forEach(element -> features.add(FeatureSetting.fromJson(element)));
        return features;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FeatureSettings)) {
            return false;
        }
        FeatureSettings fs = (FeatureSettings)obj;
        return this.globals().equals(fs.globals()) && this.features().equals(fs.features());
    }

    public int hashCode() {
        return Objects.hash(this.globals(), this.features());
    }
}

