/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.trainable_segmention.pixel_feature.settings;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.imglib2.trainable_segmention.pixel_feature.settings.ChannelSetting;

public final class GlobalSettings {
    private final ChannelSetting channelSetting;
    private final int numDimensions;
    private final List<Double> sigmas;
    private final double membraneThickness;

    public static GlobalSettings default2dSettings() {
        return new GlobalSettings(ChannelSetting.SINGLE, 2, 1.0, 16.0, 1.0);
    }

    public static GlobalSettings default3dSettings() {
        return new GlobalSettings(ChannelSetting.SINGLE, 3, 1.0, 8.0, 1.0);
    }

    public GlobalSettings(ChannelSetting channelSetting, int numDimensions, List<Double> sigmas, double membraneThickness) {
        this.channelSetting = channelSetting;
        this.numDimensions = numDimensions;
        this.sigmas = Collections.unmodifiableList(new ArrayList<Double>(sigmas));
        this.membraneThickness = membraneThickness;
    }

    public GlobalSettings(ChannelSetting channelSetting, int numDimensions, double minSigma, double maxSigma, double membraneThickness) {
        this(channelSetting, numDimensions, GlobalSettings.initSigmas(minSigma, maxSigma), membraneThickness);
    }

    private static List<Double> initSigmas(double minSigma, double maxSigma) {
        ArrayList<Double> sigmas = new ArrayList<Double>();
        for (double sigma = minSigma; sigma <= maxSigma; sigma *= 2.0) {
            sigmas.add(sigma);
        }
        return sigmas;
    }

    public GlobalSettings(GlobalSettings globalSettings) {
        this(globalSettings.channelSetting(), globalSettings.numDimensions(), globalSettings.sigmas(), globalSettings.membraneThickness());
    }

    public ChannelSetting channelSetting() {
        return this.channelSetting;
    }

    public int numDimensions() {
        return this.numDimensions;
    }

    public List<Double> sigmas() {
        return this.sigmas;
    }

    public double membraneThickness() {
        return this.membraneThickness;
    }

    public int hashCode() {
        return Objects.hash(this.sigmas, this.numDimensions, this.membraneThickness, this.channelSetting);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GlobalSettings)) {
            return false;
        }
        GlobalSettings settings = (GlobalSettings)obj;
        return this.channelSetting.equals(settings.channelSetting) && this.sigmas.equals(settings.sigmas) && this.membraneThickness == settings.membraneThickness;
    }
}

